#!/usr/bin/env python
# encoding: utf-8

"""
growl.py

Notify the user via Growl that his tea (or what else) is ready. There is a
fallback with AppleScript if the Growl python binding somehow can’t be imported.

"""

import sys


py_growl = False
try:
    from lib import Growl
    py_growl = True
except ImportError:
	pass


def py_notify(title, message, icon):
    """Notifies the user via the Growl python binding."""
    icon = Growl.Image.imageFromPath(icon)
    notifier = Growl.GrowlNotifier(
            applicationName = 'Tea Timer',
            notifications = ['TimerTargetReached'],
            applicationIcon = icon
    )
    notifier.register()
    notifier.notify('TimerTargetReached', title, message)

def as_notify(title, message, icon):
    """Notifies the user via an AppleScript."""
    from os import getcwd
    from os.path import join
    import subprocess

    icon = join(getcwd(), icon)
    cmd = ['/usr/bin/osascript', 'growl.scpt', title, message, icon]
    subprocess.call(cmd)

def main(argv):
    """
    Notify the user via the Growl python binding if the module could be loaded
    or via an AppleScript.

    """
    icon = 'Images/alarmclock.png'
    fn = py_notify if py_growl else as_notify
    fn(argv[1], argv[2], icon)


if __name__ == '__main__':
    if len(sys.argv) > 1:
      exit(main(sys.argv))
    else:
      exit(2)
	